USE [NWIC_PanelMgmt]
GO

/****** Object:  View [App].[vAllergies]    Script Date: 1/27/2016 2:44:07 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [App].[vAllergies] AS
--=================================================================================
--Requestor		        : Non Va Coordinated Care Project
--Author                : Jerry Kohler
--Object/SP Name	    : vAllergies
--SERVER		        : DNS.URL        
--Data Base		        : NWIC_PanelMgmt
--Schema		        : app
--Report		        : N/A
--Folder		        : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Last Changed          : 01-27-2016  
--Last Changed By	    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change	    : This view is created from the stored procedure
--                        NVA.GetAllergies in order to facilitate asynchronous
--                        processing by the application.  The application will
--                        take care of passing the patient SID.
--
--Purpose               : Retrieve a patient's appointments for inclusion into NVCC
--                        documentation
--=================================================================================
SELECT distinct a.Sta3n
               ,App.udf_StationName (a.Sta3n) AS StationName
               ,a.AllergySID
               ,a.PatientSID
               ,a.OriginationDateTime
               ,a.VerificationDateTime
               ,a.AllergicReactant as allergy
 FROM CDWWork.Allergy.Allergy a
WHERE a.EnteredInErrorFlag IS NULL;

GO
